/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__ENDPOINT_H
#define MX__ENDPOINT_H

#include "mx__request.h"
#include "mx__partner.h"
#include "mx__handle_map.h"
#include "mx_extensions.h"

#define CTXID_FROM_MATCHING(ep, match) ((uint32_t)(((match) >> (ep)->ctxid_shift) & ((ep)->ctxid_max-1)))
#define CHECK_MATCHING_WITH_CTXID(ep, match) (((match) & (ep)->ctxid_mask) == (ep)->ctxid_mask)

extern struct mx_endpoint *Mx_endpoints;

static inline union mx_request *
mx__endpoint_match_receive(mx_endpoint_t ep, struct mx__partner * partner,
			   uint64_t match_info, uint32_t msg_length,
			   void *data_if_available, uint32_t *discard)
{
  union mx_request *r;
  uint32_t ctxid = CTXID_FROM_MATCHING(ep, match_info);
  r = mx__find_receive_by_match_info(&(ep)->ctxid[ctxid].recv_reqq, match_info);
  if (r)
    MX__EP_STATS_INC(ep, expected);
  else
    MX__EP_STATS_INC(ep, unexpected);
  if (!r && ep->unexp_handler) {
    mx_unexp_handler_t handler = ep->unexp_handler;
    void * context = ep->unexp_handler_context;
    mx_unexp_handler_action_t ret;
    mx_endpoint_addr_t source;
    mx__partner_to_addr(partner, &source);    
    ep->in_handler = 1;
    MX__MUTEX_UNLOCK(&ep->lock);
    ret = handler(context, source, match_info, msg_length, data_if_available);
    MX__MUTEX_LOCK(&ep->lock);
    ep->in_handler = 0;
    MX__EVENT_SIGNAL(&ep->in_handler_event);
    if (ret == MX_RECV_FINISHED) {
      if (!data_if_available && msg_length)
	mx_fatal("Cannot discard unexpected if the data is not already available and the length non-null.\n");
      /* the handler took care of the message, we now discard it */
      *discard = 1;
      return NULL;
    }

    mx_assert(ret == MX_RECV_CONTINUE);
    /* the unexp has been noticed check if a recv has been posted */
    r = mx__find_receive_by_match_info(&(ep)->ctxid[ctxid].recv_reqq, match_info);
    if (r)
      MX__EP_STATS_INC(ep, unexpected_handled);
  }
  *discard = 0;
  return r;
}

#define mx__endpoint_match_unexpected(ep, match_info, match_mask) \
mx__find_request_by_matching(&(ep)->ctxid[CTXID_FROM_MATCHING(ep, match_info)].unexpq, match_info, match_mask)

#define mx__endpoint_match_partial_request(ep, msg_seq, partner) \
mx__find_partner_receive_by_msg_seq(&(partner)->partialq, msg_seq)

#define mx__endpoint_alloc_mcp_handle(ep) mx__hm_alloc((ep)->handle_map)
#define mx__endpoint_free_mcp_handle(ep,idx) mx__hm_free((ep)->handle_map,idx)

static inline int
mx__endpoint_avail_mcp_handle(struct mx_endpoint *ep)
{
  int avail = mx__hm_avail(ep->handle_map);
  if (avail)
    MX__EP_STATS_INC(ep, got_mcp_handle);
  else
    MX__EP_STATS_INC(ep, no_mcp_handle);
  return avail;
}

void mx__conservation_of_matter(struct mx_endpoint *ep);

void mx__endpoint_init_eventq(struct mx_endpoint *ep);
void mx__endpoint_init_recvq(struct mx_endpoint *ep);

void mx__dump_endpoint_stats(struct mx_endpoint *ep);

#endif /* ENDPOINT_H */

